//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Add func's for SDK examples
//------------------------------------------------------------------------------
#include "ex_util.h"
#include <fcntl.h>
#include <sys/stat.h>
#ifdef WIND32
 #include <windows.h>
 #include <wincrypt.h>
#else
 #include <unistd.h>
 #include <stdlib.h>
 #include "wdefs.h"
#endif
//------------------------------------------------------------------------------
int getFileLen(const char *path, DWORD *size)
{
 struct stat st;
 if (stat(path,&st)) return 1;
 (*size)=(DWORD)st.st_size;
 return 0;
}
//------------------------------------------------------------------------------
int readFile(const char *path, unsigned char *Mass, DWORD szMass)
{
 int inf;
#ifdef WIND32 
 if ((inf=open(path,O_RDONLY|O_BINARY ))==(-1))  return 1;
#else
 if ((inf=open(path,O_RDONLY          ))==(-1))  return 1;
#endif 
 if (read(inf,Mass,szMass)!=szMass) {close(inf); return 2;}
 close(inf);
 return 0;
}
//------------------------------------------------------------------------------
int writeFile(const char *path, unsigned char *Mass, DWORD szMass)
{
 int ouf;
 unlink(path);
#ifdef WIND32
 _fmode=O_BINARY;
#ifdef _MSC_VER
 if ((ouf=_creat(path,S_IWRITE))<0)               return 1;
#else
 if ((ouf=creat(path,S_IRUSR|S_IWUSR))<0)         return 1;
#endif
#else
 if ((ouf=creat(path,S_IRUSR|S_IWUSR))<0)         return 1;
#endif
 if (write(ouf,Mass,szMass)!=szMass) {close(ouf); return 2;}
 close(ouf);
 return 0;
}
//------------------------------------------------------------------------------
DWORD GetLastErrorCSP(HCRYPTPROV hProv)
{
 DWORD code,len=sizeof(DWORD);
 if (!CPGetProvParam(hProv,PP_LAST_ERROR,(BYTE*)&code,&len,0))
   CPGetProvParam(0,PP_LAST_ERROR,(BYTE*)&code,&len,0);
 return code;
}
//------------------------------------------------------------------------------
const char *code2fail(DWORD code)
{
 switch(code) {
   case PKIFAILURE_INFO_BAD_ALG               : return "unrecognized or unsupported Algorithm Identifier";
   case PKIFAILURE_INFO_BAD_MESSAGE_CHECK     : return "integrity check failed (e.g., signature did not verify)";
   case PKIFAILURE_INFO_BAD_REQUEST           : return "transaction not permitted or supported";
   case PKIFAILURE_INFO_BAD_TIME              : return "messageTime was not sufficiently close to the system time, as defined by local policy";
   case PKIFAILURE_INFO_BAD_CERT_ID           : return "no certificate could be found matching the provided criteria";
   case PKIFAILURE_INFO_BAD_DATA_FORMAT       : return "the data submitted has the wrong format";
   case PKIFAILURE_INFO_WRONG_AUTHORITY       : return "the authority indicated in the request is different from the one creating the response token";
   case PKIFAILURE_INFO_INCORRECT_DATA        : return "the requester's data is incorrect (for notary services)";
   case PKIFAILURE_INFO_MISSING_TIME_STAMP    : return "when the timestamp is missing but should be there (by policy)";
   case PKIFAILURE_INFO_BAD_POP               : return "the proof-of-possession failed";
   case PKIFAILURE_INFO_CERT_REVOKED          : return "the certificate has already been revoked";
   case PKIFAILURE_INFO_CERT_CONFIRMED        : return "the certificate has already been confirmed";
   case PKIFAILURE_INFO_WRONG_INTEGRITY       : return "invalid integrity, password based instead of signature or vice versa";
   case PKIFAILURE_INFO_BAD_RECIPIENT_NONCE   : return "invalid recipient nonce, either missing or wrong value";
   case PKIFAILURE_INFO_TIME_NOT_AVAILABLE    : return "the TSA's time source is not available";
   case PKIFAILURE_INFO_UNACCEPTED_POLICY     : return "the requested TSA policy is not supported by the TSA";
   case PKIFAILURE_INFO_UNACCEPTED_EXTENSION  : return "the requested extension is not supported by the TSA";
   case PKIFAILURE_INFO_ADD_INFO_NOT_AVAILABLE: return "the additional information requested could not be understood or is not available";
   case PKIFAILURE_INFO_BAD_SENDER_NONCE      : return "invalid sender nonce, either missing or wrong size";
   case PKIFAILURE_INFO_BAD_CERT_TEMPLATE     : return "invalid certificate template or missing mandatory information";
   case PKIFAILURE_INFO_SIGNER_NOT_TRUSTED    : return "signer of the message unknown or not trusted";
   case PKIFAILURE_INFO_TRANSACTION_ID_IN_USE : return "the transaction identifier is already in use";
   case PKIFAILURE_INFO_UNSUPPORTED_VERSION   : return "the version of the message is not supported";
   case PKIFAILURE_INFO_NOT_AUTHORISED        : return "not authorised";
   case PKIFAILURE_INFO_SYSTEM_UNAVAIL        : return "the request cannot be handled due to system unavailability";
   case PKIFAILURE_INFO_SYSTEM_FAILURE        : return "the request cannot be handled due to system failure";
   case PKIFAILURE_INFO_DUPLICATE_CERT_REQ    : return "certificate cannot be issued because a duplicate certificate already exists";
 }
 return "Unknown";
}
//------------------------------------------------------------------------------
const char *code2status(DWORD code)
{
 switch(code) {
   case PKISTATUS_INFO_ACCEPTED               : return "ACCEPTED";
   case PKISTATUS_INFO_GRANTED_WITH_MODS      : return "GRANTED_WITH_MODS";
   case PKISTATUS_INFO_REJECTION              : return "REJECTION";
   case PKISTATUS_INFO_WAITING                : return "WAITING";
   case PKISTATUS_INFO_REVOCATION_WARNING     : return "REVOCATION_WARNING";
   case PKISTATUS_INFO_REVOCATION_NOTIFICATION: return "REVOCATION_NOTIFICATION";
   case PKISTATUS_INFO_KEY_UPDATE_WARNING     : return "KEY_UPDATE_WARNING";
 }
 return "Unknown";
}
//------------------------------------------------------------------------------
